class Search
  def initialize(driver)
    @driver = driver
    @wait = Selenium::WebDriver::Wait.new(:timeout => 20)
    @searchWait = Selenium::WebDriver::Wait.new(:timeout => 25)
  end

  def search
    return Search.new(@driver)
  end

#replace with following
=begin
  def initialize(driver)
    @driver = driver
  end

  def search
    return Search.new(@driver)
  end
=end

  def getSearchHeader
    return @driver.find_element(:css, ".ui-dialog-contain .ui-title").text()
  end
  
  def setTestPatient(patient, row)
    if(not @driver.find_element(:css, "#patient-context").text().downcase.start_with? patient)
      searchByPatient(patient)
      selectAndConfirmPatientAtRow(row)
    end
  end
  
  def searchByPatient(patient)
    openSearchMenu()
    selectPatientSearch()
    @searchWait.until{element_present?(:css, "#primary-search-filter input")}
    @driver.find_element(:css, "#primary-search-filter input").clear
    @driver.find_element(:css, "#primary-search-filter input").send_keys patient
    @driver.find_element(:css, "#primary-search-filter input").send_keys :enter
      #wait for search results
    @searchWait.until{element_present?(:css, "#patient-list li")}
  end
  
  def searchByWard(ward)
    openSearchMenu()
    selectWardSearch()
    @searchWait.until{ element_present?(:css, "input.ui-input-text") }
    @driver.find_element(:css, "input.ui-input-text").clear
    @driver.find_element(:css, "input.ui-input-text").send_keys ward
    sleep(1)
    @driver.find_element(:css, "input.ui-input-text").send_keys " "

    #wait for search results
    @searchWait.until{ element_present?(:css, "#location-list li:not(.ui-screen-hidden)") }
  end
  
  def searchByClinic(clinic)
    openSearchMenu()
    selectClinicSearch()
    sleep(1)
    @driver.find_element(:css, "#primary-search-filter .ui-input-search input").clear
    @driver.find_element(:css, "#primary-search-filter .ui-input-search input.ui-input-text.ui-body-b").send_keys clinic

    #wait for search results
    @searchWait.until{ element_present?(:css, "#location-list li:not(.ui-screen-hidden)") }
  end
  
  def filterClinicByDate(month, day, year)
    arrMonth = ['JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN', 'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC']

    @wait.until{ element_present?(:css, "#date-filter") }
    @driver.find_element(:css, "#date-filter").click
    # jQM-generated container #date-picker-popup contains #date-picker
    @wait.until{ element_present?(:css, "#date-picker-popup.ui-popup-active .year") }

    #Select year first to enable months that not be available in the present year
    puts "clinic search #date-picker by year " + year.to_s
    @driver.find_element(:css, "#date-picker .year button[data-value='" + year.to_s + "']").click()

    monthCssRow = ( month.is_a? Integer or month.to_i != 0 ) ? month : (arrMonth.index(month.upcase) + 1)
    puts "clinic search #date-picker by month " + monthCssRow.to_s
    @driver.find_element(:css, "#date-picker .month li:nth-of-type(" + monthCssRow.to_s + ") button").click()

    puts "clinic search #date-picker by day " + day.to_s
    @driver.find_element(:css, "#date-picker .day li:nth-of-type(" + day.to_s + ") button").click()
    @driver.find_element(:css, "#set-btn").click()

    @wait.until{ element_present?(:css, "#date-picker-popup.ui-popup-hidden") }
  end
  
  def filterSearchResults(patient)
    @driver.find_element(:css, "#secondary-search-filter input").clear
    @driver.find_element(:css, "#secondary-search-filter input").send_keys patient
    @driver.find_element(:css, "#secondary-search-filter input").send_keys :enter
  end
  
  def clearFilterSearchResultsField
#    if(not element_present?(:css, "#secondary-search-filter a.ui-input-clear-hidden"))
        @driver.find_element(:css, "#secondary-search-filter a.ui-input-clear .ui-icon-delete").click
 #   end
  end
  
  def clearPrimarySearchField
    if(not element_present?(:css, "#primary-search-filter a.ui-input-clear-hidden"))
      @driver.find_element(:css, "#primary-search-filter a .ui-icon-delete").click
      !5.times{ break if (getSearchResultsLength() == 0); sleep 1 }
    end
  end
  
  def getSearchResultsLength
    return getElements(:css, '#patient-list li:not(.ui-li-divider)').length
  end
  
  def getFacilitySearchResultsLength
    return getElements(:css, '#location-list li:not(.ui-screen-hidden)').length
  end
  
  
  def getSearchResultDisplayCount
    return @driver.find_element(:css, "#patient-list li.ui-li-divider span:nth-of-type(1)").text()
  end
  
  def getPatientNameAtRow(row)
    cssRow = row
    # do not count header
    if ( element_present?(:css, "#patient-list li.ui-li-divider:first-of-type") )
      cssRow += 1
    end

    @wait.until{ element_present?(:css, "#patient-list li:nth-of-type(" + cssRow.to_s + ") h3") }
    return @driver.find_element(:css, "#patient-list li:nth-of-type(" + cssRow.to_s + ") h3").text()
  end
  
  def getExpectedPatientAtRow(row, patient)
    cssRow = row
    # do not count header
    if ( element_present?(:css, "#patient-list li.ui-li-divider:first-of-type") )
      cssRow += 1
    end

    !5.times{ break if (@search.getPatientNameAtRow(1) == patient rescue false); sleep 1 }
    return @driver.find_element(:css, "#patient-list li:nth-of-type(" + cssRow.to_s + ") h3").text() === patient
  end

  def getPatientSsnAtRow(row)
    cssRow = row
    # do not count header
    if ( element_present?(:css, "#patient-list li.ui-li-divider:first-of-type") )
      cssRow += 1
    end

    return @driver.find_element(:css, "#patient-list li:nth-of-type(" + cssRow.to_s + ") p:nth-of-type(2)").text()
  end
  

  def getNoResultsFound()
    return @driver.find_element(:xpath, "//ul[@id='patient-list']/li").text
  end    
  
  def selectPatientAtRow(row)
    @wait.until{ @driver.find_element(:css, "#patient-list li") }
    cssRow = row
    # do not count header (OBE)
    if ( element_present?(:css, "#patient-list li.ui-li-divider:first-of-type") )
      cssRow += 1
    end

    @wait.until { element_present?(:css, "#patient-list li:nth-of-type(" + cssRow.to_s + ") a.ui-link-inherit") }
    @driver.find_element(:css, "#patient-list li:nth-of-type(" + cssRow.to_s + ") a.ui-link-inherit").click
  end
  
  def selectPatientFromSearchResultsList(patientName)
    @wait.until{ @driver.find_element(:css, "#patient-list li") }
    @results = @driver.find_elements(:css, "#patient-list li")
    initRow = 0
    # do not count header
    if ( element_present?(:css, "#patient-list li.ui-li-divider:first-of-type") )
      initRow += 1
    end

    for i in (initRow..@results.size-1) 
      @result = @results[i]
      if (@result.find_element(:tag_name, "h3").text == patientName.upcase)
        #puts "@result.tag_name: #{@result.tag_name}"
        #puts "patient search @result item: #{@result.find_element(:tag_name, "h3").text}"
        @result.find_element(:tag_name, "a").click
        break
      end
    end
  end
  
  def getPopupFirstName
    return @driver.find_element(:css, "#confirmation li:nth-of-type(2)").text
  end
  
  def getPopupLastName 
    return @driver.find_element(:css, "#confirmation li:nth-of-type(1)").text
  end
  
  def getPopupSsn
    return @driver.find_element(:css, "#confirmation li:nth-of-type(7)").text
  end
  
def selectWardAtRow(row)
  !5.times{ break if (element_present?(:css, "#location-list li:nth-of-type(" + row.to_s + "):not(.ui-screen-hidden) a") rescue false); sleep 1 }
  @driver.find_element(:css, "#location-list li:nth-of-type(" + row.to_s + "):not(.ui-screen-hidden) a").click
#  @driver.find_element(:xpath, "//ul[@id='location-list']/li[4]/div/div/a/h3").click
end

  def selectClinicAtRow(row)
    @driver.find_element(:css, "#location-list li:nth-of-type(" + row.to_s + ") a.ui-link-inherit").click
#    @driver.find_element(:xpath, "//ul[@id='location-list']/li[7]/div/div/a/h3").click
  end

    
  def openPopupForPatientAtRow(row)
    cssRow = row
    # do not count header
    if ( element_present?(:css, "#patient-list li.ui-li-divider:first-of-type") )
      cssRow += 1
    end

    @driver.find_element(:css, "#patient-list li:nth-of-type(" + cssRow.to_s + ") h3").click
  end
  
  def openSearchMenu
    # for SUD
    if(element_present?(:css, ".ui-content ol"))
      @driver.find_element(:css, "#accept-btn").click()
      sleep(2)
    end
    @wait.until{  @driver.find_element(:css, "#patient-search a").displayed? }
    @driver.find_element(:css, "#patient-search a").click
    @wait.until{ element_present?(:css, "#search") }
  end
  
  def selectLast20
    @wait.until{ @driver.find_element(:css, "#portal-modal .ui-block-d a").displayed? }
    @driver.find_element(:css, "#portal-modal .ui-block-d a").click
  end
  
  def selectWardSearch
    @wait.until{ element_present?(:css, "#portal-modal .ui-block-c a") }
    @driver.find_element(:css, "#portal-modal .ui-block-c a").click
#      !5.times{ break if (element_present?(:css, "#primary-search-filter [placeholder='Search Wards...']") rescue false); sleep 1 }
  !5.times{ break if (element_present?(:css, "#location-list li:nth-of-type(" + row.to_s + "):not(.ui-screen-hidden) a") rescue false); sleep 1 }
  !5.times{ break if (element_present?(:xpath, "//div[@id='search-type-menu']/ul/li[2]/a/span") rescue false); sleep 1 }
  end

  def selectClinicSearch
    @wait.until{ element_present?(:css, "#portal-modal .ui-block-b a") }
    @driver.find_element(:css, "#portal-modal .ui-block-b a").click
#      !5.times{ break if (element_present?(:css, "#primary-search-filter [placeholder='Search Clinics...']") rescue false); sleep 1 }
    !5.times{ break if (element_present?(:xpath, "//div[@id='search-type-menu']/ul/li[3]/a/span") rescue false); sleep 1 }
  end

  def selectPatientSearch
    @driver.find_element(:css, "#portal-modal .ui-block-a a").click 
#      !5.times{ break if (element_present?(:css, "#primary-search-filter [placeholder='Search Patient By Name or SSN...']") rescue false); sleep 1 }
    !5.times{ break if (element_present?(:xpath, "//div[@id='search-type-menu']/ul/li[4]/a/span/span") rescue false); sleep 1 }
  end

#  def searchResultsContainsPatient(patient)
#
#    return false
#  end
  
  def hasPatient(patient)
    lastTwenty = getDisplayedList("#primary-search-filter li h3")
    hasInstance = false
    
    lastTwenty.each do |item|
      if item.include? patient
         #puts "String has " + patient
         hasInstance = true
         break
      end

    end
        
    return hasInstance
  end
  
  def getClinicDateFilterValue
    return @driver.find_element(:css, "#date-filter").attribute("value")
  end
  def getWardNameAtRow(row)
    !5.times{ break if (element_present?(:css, "#location-list li:nth-of-type(" + row.to_s + ") h3") rescue false); sleep 1 }
    return @driver.find_element(:css, "#location-list li:nth-of-type(" + row.to_s + ") h3").text()
  end
  
  def getClinicNameAtRow(row)
    return @driver.find_element(:css, "#location-list li:nth-of-type(" + row.to_s + ") h3").text()
  end  
  
  def getClinicList
    return @driver.find_elements(:css, "#location-list li:not(.ui-screen-hidden) h3")
  end
  
  def getSearchCriteria
    return @driver.find_element(:css, "#primary-search-filter .ui-input-search input").attribute("value")
  end
  
  def closeSearchWindow
    @driver.find_element(:css, '#portal-modal .ui-header a').click
  end
  
  def getDisplayedList(selector)
    elements = getElements(:css, selector)
    formattedElements = []
    elements.each do |item|
      formattedElements.push(item.text())
    end
    #puts(formattedElements)
    return formattedElements
  end
  
  def updatePatientContext(patientName)
    searchByPatient(patientName)
    selectAndConfirmPatientAtRow(1)
    @wait.until{ @driver.find_element(:css, "#patient-context").text().downcase.start_with? patientName.downcase }
  end
  
  def updatePatientContextByName(patientName)
    searchByPatient(patientName)
    selectAndConfirmPatient(patientName)
    @searchWait.until{ @driver.find_element(:css, "#patient-context").text().downcase.start_with? patientName.downcase }
  end

  private
  def selectAndConfirmPatientAtRow(row)
    selectPatientAtRow(row)
    @wait.until{ @driver.find_element(:css, "#confirm-button") }
    @driver.find_element(:css, "#confirm-button").click
  end

  def selectAndConfirmPatient(patientName)
    selectPatientFromSearchResultsList(patientName)
    @wait.until{ @driver.find_element(:css, "#confirm-button") }
    @driver.find_element(:css, "#confirm-button").click
  end
  
end
